<?php
// Include your database connection code here (e.g., dbconn.php)
require_once 'includes/dbconn.php';

// Fetch total debit (expenses)
$sqlTotalDebit = "SELECT COALESCE(SUM(amount), 0) AS total_debit FROM expenses";
$resultTotalDebit = $conn->query($sqlTotalDebit);
$rowTotalDebit = $resultTotalDebit->fetch_assoc();
$totalDebit = $rowTotalDebit['total_debit'];

// Fetch total credit (paid invoices)
$sqlTotalCredit = "SELECT COALESCE(SUM(total_amount), 0) AS total_credit FROM invoices WHERE payment_status = 'Paid'";
$resultTotalCredit = $conn->query($sqlTotalCredit);
$rowTotalCredit = $resultTotalCredit->fetch_assoc();
$totalCredit = $rowTotalCredit['total_credit'];

// Prepare the data in JSON format
$data = array(
    'totalDebit' => $totalDebit,
    'totalCredit' => $totalCredit
);

// Output JSON response
header('Content-Type: application/json');
echo json_encode($data);
$conn->close();
?>
