<?php include 'services/session.php'; ?>
<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "Form Components";
    include 'partials/title-meta.php'; ?>

    <?php include 'partials/head-css.php'; ?>

</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">

    <?php $pagetitle = "Form Components";
    include 'partials/menu.php'; ?>
            
            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="header-title">Input Types</h4>
                                        <p class="sub-header">
                                            Most common form control, text-based input fields. Includes support for all HTML5 types: <code>text</code>, <code>password</code>, <code>datetime</code>, <code>datetime-local</code>, <code>date</code>, <code>month</code>, <code>time</code>, <code>week</code>, <code>number</code>, <code>email</code>, <code>url</code>, <code>search</code>, <code>tel</code>, and <code>color</code>.
                                        </p>

                                        <div class="row">
                                            <div class="col-lg-6">
                                                <form>

                                                    <div class="mb-3">
                                                        <label for="simpleinput" class="form-label">Text</label>
                                                        <input type="text" id="simpleinput" class="form-control">
                                                    </div>

                                                    <div class="mb-3">
                                                        <label for="example-email" class="form-label">Email</label>
                                                        <input type="email" id="example-email" name="example-email" class="form-control" placeholder="Email">
                                                    </div>

                                                    <div class="mb-3">
                                                        <label for="example-password" class="form-label">Password</label>
                                                        <input type="password" id="example-password" class="form-control" value="password">
                                                    </div>

                                                    <div class="mb-3">
                                                        <label for="password" class="form-label">Show/Hide Password</label>
                                                        <div class="input-group input-group-merge">
                                                            <input type="password" id="password" class="form-control" placeholder="Enter your password">
                                                            <div class="input-group-text" data-password="false">
                                                                <span class="password-eye"></span>
                                                            </div>
                                                        </div>
                                                    </div>
        
                                                    <div class="mb-3">
                                                        <label for="example-palaceholder" class="form-label">Placeholder</label>
                                                        <input type="text" id="example-palaceholder" class="form-control" placeholder="placeholder">
                                                    </div>

                                                    <div class="mb-3">
                                                        <label for="example-textarea" class="form-label">Text area</label>
                                                        <textarea class="form-control" id="example-textarea" rows="5"></textarea>
                                                    </div>
        
                                                    <div class="mb-3">
                                                        <label for="example-readonly" class="form-label">Readonly</label>
                                                        <input type="text" id="example-readonly" class="form-control" readonly="" value="Readonly value">
                                                    </div>

                                                    <div class="mb-3">
                                                        <label for="example-disable" class="form-label">Disabled</label>
                                                        <input type="text" class="form-control" id="example-disable" disabled="" value="Disabled value">
                                                    </div>
    
                                                    <div class="mb-3">
                                                        <label for="example-static" class="form-label">Static control</label>
                                                        <input type="text" readonly class="form-control-plaintext" id="example-static" value="email@example.com">
                                                    </div>

                                                    <div>
                                                        <label for="example-helping" class="form-label">Helping text</label>
                                                        <input type="text" id="example-helping" class="form-control" placeholder="Helping text">
                                                        <span class="help-block"><small>A block of help text that breaks onto a new line and may extend beyond one line.</small></span>
                                                    </div>
        
                                                </form>
                                            </div> <!-- end col -->

                                            <div class="col-lg-6">
                                                <form>
        
                                                    <div class="mb-3">
                                                        <label for="example-select" class="form-label">Input Select</label>
                                                        <select class="form-select" id="example-select">
                                                            <option>1</option>
                                                            <option>2</option>
                                                            <option>3</option>
                                                            <option>4</option>
                                                            <option>5</option>
                                                        </select>
                                                    </div>

                                                    <div class="mb-3">
                                                        <label for="example-multiselect" class="form-label">Multiple Select</label>
                                                        <select id="example-multiselect" multiple class="form-select">
                                                            <option>1</option>
                                                            <option>2</option>
                                                            <option>3</option>
                                                            <option>4</option>
                                                            <option>5</option>
                                                        </select>
                                                    </div>
        
                                                    <div class="mb-3">
                                                        <label for="example-fileinput" class="form-label">Default file input</label>
                                                        <input type="file" id="example-fileinput" class="form-control">
                                                    </div>
        
                                                    <div class="mb-3">
                                                        <label for="example-date" class="form-label">Date</label>
                                                        <input class="form-control" id="example-date" type="date" name="date">
                                                    </div>
        
                                                    <div class="mb-3">
                                                        <label for="example-month" class="form-label">Month</label>
                                                        <input class="form-control" id="example-month" type="month" name="month">
                                                    </div>
        
                                                    <div class="mb-3">
                                                        <label for="example-time" class="form-label">Time</label>
                                                        <input class="form-control" id="example-time" type="time" name="time">
                                                    </div>
        
                                                    <div class="mb-3">
                                                        <label for="example-week" class="form-label">Week</label>
                                                        <input class="form-control" id="example-week" type="week" name="week">
                                                    </div>
        
                                                    <div class="mb-3">
                                                        <label for="example-number" class="form-label">Number</label>
                                                        <input class="form-control" id="example-number" type="number" name="number">
                                                    </div>
        
                                                    <div class="mb-3">
                                                        <label for="example-color" class="form-label">Color</label>
                                                        <input class="form-control" id="example-color" type="color" name="color" value="#71b6f9">
                                                    </div>
        
                                                    <div>
                                                        <label for="example-range" class="form-label">Range</label>
                                                        <input class="form-range" id="example-range" type="range" name="range" min="0" max="100">
                                                    </div>
        
                                                </form>
                                            </div> <!-- end col -->
                                        </div>
                                        <!-- end row-->

                                    </div> <!-- end card-body -->
                                </div> <!-- end card -->
                            </div><!-- end col -->
                        </div>
                        <!-- end row -->

                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <h4 class="header-title">Select menu</h4>
                                                <p class="sub-header">
                                                    Custom <code>&lt;select&gt;</code> menus need only a custom class, <code>.form-select</code> to trigger the custom styles.
                                                </p>
    
                                                <select class="form-select">
                                                    <option selected>Open this select menu</option>
                                                    <option value="1">One</option>
                                                    <option value="2">Two</option>
                                                    <option value="3">Three</option>
                                                </select>

                                                <h4 class="header-title mt-4">Switches</h4>
                                                <p class="sub-header">
                                                    A switch has the markup of a custom checkbox but uses the <code>.form-switch</code> class to render a toggle switch. Switches also support the <code>disabled</code> attribute.
                                                </p>

                                                <div class="form-check form-switch">
                                                    <input type="checkbox" class="form-check-input" id="customSwitch1">
                                                    <label class="form-check-label" for="customSwitch1">Toggle this switch element</label>
                                                </div>
                                                <div class="form-check form-switch mt-1">
                                                    <input type="checkbox" class="form-check-input" disabled id="customSwitch2">
                                                    <label class="form-check-label" for="customSwitch2">Disabled switch element</label>
                                                </div>

                                            </div> <!-- end col -->
    
                                            <div class="col-md-6">
                                                <h4 class="header-title mt-5 mt-sm-0">Checkboxes and radios</h4>
                                                <div class="mt-3">
                                                    <div class="form-check">
                                                        <input type="checkbox" class="form-check-input" id="customCheck1">
                                                        <label class="form-check-label" for="customCheck1">Check this custom checkbox</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="checkbox" class="form-check-input" id="customCheck2">
                                                        <label class="form-check-label" for="customCheck2">Check this custom checkbox</label>
                                                    </div>
                                                </div>
                                                <div class="mt-3">
                                                    <div class="form-check">
                                                        <input type="radio" id="customRadio1" name="customRadio" class="form-check-input">
                                                        <label class="form-check-label" for="customRadio1">Toggle this custom radio</label>
                                                    </div>
                                                    <div class="form-check">
                                                        <input type="radio" id="customRadio2" name="customRadio" class="form-check-input">
                                                        <label class="form-check-label" for="customRadio2">Or toggle this other custom radio</label>
                                                    </div>
                                                </div>
                                            </div> <!-- end col -->
                                        </div> <!-- end row -->

                                    </div> <!-- end card-body-->
                                </div> <!-- end card -->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->

                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="header-title">Floating labels</h4>
                                        <p class="sub-header">
                                            Wrap a pair of <code>&lt;input class="form-control"&gt;</code> and <code>&lt;label&gt;</code> elements in <code>.form-floating</code> to enable floating labels with Bootstrap’s textual form fields. A <code>placeholder</code> is required on each <code>&lt;input&gt;</code> as our method of CSS-only floating labels uses the <code>:placeholder-shown</code> pseudo-element. Also note that the <code>&lt;input&gt;</code> must come first so we can utilize a sibling selector (e.g., <code>~</code>).
                                        </p>
                                        <div class="row">
                                            <div class="col-lg-6">
                                                <h4 class="header-title mb-3">Floating Example</h4>

                                                <div class="form-floating mb-3">
                                                    <input type="email" class="form-control" id="floatingInput" placeholder="name@example.com">
                                                    <label for="floatingInput">Email address</label>
                                                </div>
                                                <div class="form-floating mb-3">
                                                    <input type="password" class="form-control" id="floatingPassword" placeholder="Password">
                                                    <label for="floatingPassword">Password</label>
                                                </div>
                                                <div class="form-floating">
                                                    <textarea class="form-control" placeholder="Leave a comment here" id="floatingTextarea2"
                                                        style="height: 100px"></textarea>
                                                    <label for="floatingTextarea2">Comments</label>
                                                </div>
                                            </div>

                                            <div class="col-lg-6">
                                                <h4 class="header-title mt-lg-0 my-3">Selects</h4>

                                                <div class="form-floating mb-3">
                                                    <select class="form-select" id="floatingSelect" aria-label="Floating label select example">
                                                        <option selected>Open this select menu</option>
                                                        <option value="1">One</option>
                                                        <option value="2">Two</option>
                                                        <option value="3">Three</option>
                                                    </select>
                                                    <label for="floatingSelect">Works with selects</label>
                                                </div>
                                                
                                                <div class="row g-2">
                                                    <div class="col-md">
                                                        <div class="form-floating">
                                                            <input type="email" class="form-control" id="floatingInputGrid" placeholder="name@example.com"
                                                                value="mdo@example.com">
                                                            <label for="floatingInputGrid">Email address</label>
                                                        </div>
                                                    </div>
                                                    <div class="col-md">
                                                        <div class="form-floating">
                                                            <select class="form-select" id="floatingSelectGrid" aria-label="Floating label select example">
                                                                <option selected>Open this select menu</option>
                                                                <option value="1">One</option>
                                                                <option value="2">Two</option>
                                                                <option value="3">Three</option>
                                                            </select>
                                                            <label for="floatingSelectGrid">Works with selects</label>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-lg-6">
                                <div class="card">
                                    <div class="card-body">

                                        <h4 class="header-title">Input Sizes</h4>
                                        <p class="sub-header">
                                            Set heights using classes like <code>.input-lg</code>, and set widths using grid column classes like <code>.col-lg-*</code>.
                                        </p>

                                        <form>
                                            <div class="mb-3">
                                                <label for="example-input-small" class="form-label">Small</label>
                                                <input type="text" id="example-input-small" name="example-input-small" class="form-control form-control-sm" placeholder=".input-sm">
                                            </div>

                                            <div class="mb-3">
                                                <label for="example-input-normal" class="form-label">Normal</label>
                                                <input type="text" id="example-input-normal" name="example-input-normal" class="form-control" placeholder="Normal">
                                            </div>

                                            <div class="mb-3">
                                                <label for="example-input-large" class="form-label">Large</label>
                                                <input type="text" id="example-input-large" name="example-input-large" class="form-control form-control-lg" placeholder=".input-lg">
                                            </div>

                                            <div class="mb-2">
                                                <label for="example-gridsize" class="form-label">Grid Sizes</label>
                                                <div class="row">
                                                    <div class="col-sm-4">
                                                        <input type="text" id="example-gridsize" class="form-control" placeholder=".col-sm-4">
                                                    </div>
                                                </div>
                                            </div>
                                        </form>

                                    </div> <!-- end card-body -->
                                </div> <!-- end card -->
                            </div> <!-- end col -->

                            <div class="col-lg-6">
                                <div class="card">
                                    <div class="card-body">

                                        <h4 class="header-title">Input Group</h4>
                                        <p class="sub-header">
                                            Easily extend form controls by adding text, buttons, or button groups on either side of textual inputs, custom selects, and custom file inputs
                                        </p>

                                        <form>
                                            
                                            <div class="mb-3">
                                                <label class="form-label">Static</label>
                                                <div class="input-group">
                                                    <span class="input-group-text" id="basic-addon1">@</span>
                                                    <input type="text" class="form-control" placeholder="Username" aria-label="Username" aria-describedby="basic-addon1">
                                                </div>
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Dropdowns</label>
                                                <div class="input-group">
                                                    <button class="btn input-group-text btn-primary waves-effect waves-light dropdown-toggle" type="button" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">Dropdown</button>
                                                    <div class="dropdown-menu">
                                                        <a class="dropdown-item" href="#">Action</a>
                                                        <a class="dropdown-item" href="#">Another action</a>
                                                        <a class="dropdown-item" href="#">Something else here</a>
                                                    </div>
                                                    <input type="text" class="form-control" placeholder="" aria-label="" aria-describedby="basic-addon1">
                                                </div>
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Buttons</label>
                                                <div class="input-group">
                                                    <input type="text" class="form-control" placeholder="Recipient's username" aria-label="Recipient's username">
                                                    <button class="btn input-group-text btn-dark waves-effect waves-light" type="button">Button</button>
                                                </div>
                                            </div>

                                            <div class="mb-0">
                                                <div class="row">
                                                    <div class="col-xl-6">
                                                        <div class="mb-3 mb-xl-0">
                                                            <label for="inputGroupFile04" class="form-label">Default file input</label>
                                                            <input class="form-control" type="file" id="inputGroupFile04">
                                                        </div>
                                                    </div>
                                                    <div class="col-xl-6">
                                                        <div class="">
                                                            <label for="formFileMultiple" class="form-label">Multiple files input</label>
                                                            <input class="form-control" type="file" id="formFileMultiple" multiple>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </form>

                                    </div> <!-- end card-body -->
                                </div> <!-- end card -->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->


                        <div class="row">
                            <div class="col-lg-6">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="mb-3 header-title">Basic Example</h4>

                                        <form>
                                            <div class="mb-3">
                                                <label for="exampleInputEmail1" class="form-label">Email address</label>
                                                <input type="email" class="form-control" id="exampleInputEmail1" aria-describedby="emailHelp" placeholder="Enter email">
                                                <small id="emailHelp" class="form-text text-muted">We'll never share your email with anyone else.</small>
                                            </div>
                                            <div class="mb-3">
                                                <label for="exampleInputPassword1" class="form-label">Password</label>
                                                <input type="password" class="form-control" id="exampleInputPassword1" placeholder="Password">
                                            </div>
                                            <div class="mb-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" id="checkmeout0">
                                                    <label class="form-check-label" for="checkmeout0">Check me out !</label>
                                                </div>
                                            </div>
                                            <button type="submit" class="btn btn-primary waves-effect waves-light">Submit</button>
                                        </form>

                                    </div> <!-- end card-body-->
                                </div> <!-- end card-->
                            </div>
                            <!-- end col -->

                            <div class="col-lg-6">
                                <div class="card">
                                    <div class="card-body">

                                        <h4 class="mb-3 header-title">Horizontal form</h4>

                                        <form class="form-horizontal">
                                            <div class="row mb-3">
                                                <label for="inputEmail3" class="col-4 col-xl-3 col-form-label">Email</label>
                                                <div class="col-8 col-xl-9">
                                                    <input type="email" class="form-control" id="inputEmail3" placeholder="Email">
                                                </div>
                                            </div>
                                            <div class="row mb-3">
                                                <label for="inputPassword3" class="col-4 col-xl-3 col-form-label">Password</label>
                                                <div class="col-8 col-xl-9">
                                                    <input type="password" class="form-control" id="inputPassword3" placeholder="Password">
                                                </div>
                                            </div>
                                            <div class="row mb-3">
                                                <label for="inputPassword5" class="col-4 col-xl-3 col-form-label">Re Password</label>
                                                <div class="col-8 col-xl-9">
                                                    <input type="password" class="form-control" id="inputPassword5" placeholder="Retype Password">
                                                </div>
                                            </div>
                                            <div class="row mb-3 justify-content-end">
                                                <div class="col-8 col-xl-9">
                                                    <div class="form-check">
                                                        <input type="checkbox" class="form-check-input" id="checkmeout">
                                                        <label class="form-check-label" for="checkmeout">Check me out !</label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="justify-content-end row">
                                                <div class="col-8 col-xl-9">
                                                    <button type="submit" class="btn btn-info waves-effect waves-light">Sign in</button>
                                                </div>
                                            </div>
                                        </form>

                                    </div>  <!-- end card-body -->
                                </div>  <!-- end card -->
                            </div>  <!-- end col -->

                        </div>
                        <!-- end row -->


                        <!-- Inline Form -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-body">

                                        <h4 class="header-title">Column sizing</h4>

                                        <p class="sub-header">
                                            As shown in the previous examples, our grid system allows you to place any number of  <code>.col</code>s within a <code>.row</code>.
                                        </p>

                                        <form class="row g-3">
                                            <div class="col-xl-2 col-md-3">
                                                <label for="staticEmail2" class="visually-hidden">Email</label>
                                                <input type="text" readonly class="form-control-plaintext" id="staticEmail2" value="email@example.com">
                                            </div>
                                            <div class="col-xl-2 col-md-3">
                                                <label for="inputPassword2" class="visually-hidden">Password</label>
                                                <input type="password" class="form-control" id="inputPassword2" placeholder="Password">
                                            </div>
                                            <div class="col-xl-2 col-md-3">
                                                <button type="submit" class="btn btn-primary waves-effect waves-light">Confirm identity</button>
                                            </div>
                                        </form>
    
                                        <h6 class="font-13 mt-3">Auto-sizing</h6>
    
                                        <form>
                                            <div class="row align-items-center">
                                                <div class="col-auto">
                                                    <label class="visually-hidden" for="inlineFormInput">Name</label>
                                                    <input type="text" class="form-control mb-2" id="inlineFormInput" placeholder="Jane Doe">
                                                </div>
                                                <div class="col-auto">
                                                    <label class="visually-hidden" for="inlineFormInputGroup">Username</label>
                                                    <div class="input-group mb-2">
                                                        <div class="input-group-text">@</div>
                                                        <input type="text" class="form-control" id="inlineFormInputGroup" placeholder="Username">
                                                    </div>
                                                </div>
                                                <div class="col-auto">
                                                    <div class="form-check mb-2">
                                                        <input type="checkbox" class="form-check-input" id="autoSizingCheck">
                                                        <label class="form-check-label" for="autoSizingCheck">Remember me</label>
                                                    </div>
                                                </div>
                                                <div class="col-auto">
                                                    <button type="submit" class="btn btn-primary waves-effect waves-light mb-2">Submit</button>
                                                </div>
                                            </div>
                                        </form>

                                    </div> <!-- end card-body -->
                                </div> <!-- end card -->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->



                        <!-- Form row -->
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="header-title">Gutters</h4>
                                        <p class="text-muted font-13">More complex layouts can also be created with the grid system.</p>

                                        <form>
                                            <div class="row">
                                                <div class="col-md-6 mb-3">
                                                    <label for="inputEmail4" class="form-label">Email</label>
                                                    <input type="email" class="form-control" id="inputEmail4" placeholder="Email">
                                                </div>
                                                <div class="col-md-6 mb-3">
                                                    <label for="inputPassword4" class="form-label">Password</label>
                                                    <input type="password" class="form-control" id="inputPassword4" placeholder="Password">
                                                </div>
                                            </div>

                                            <div class="mb-3">
                                                <label for="inputAddress" class="form-label">Address</label>
                                                <input type="text" class="form-control" id="inputAddress" placeholder="1234 Main St">
                                            </div>

                                            <div class="mb-3">
                                                <label for="inputAddress2" class="form-label">Address 2</label>
                                                <input type="text" class="form-control" id="inputAddress2" placeholder="Apartment, studio, or floor">
                                            </div>

                                            <div class="row">
                                                <div class="mb-3 col-md-6">
                                                    <label for="inputCity" class="form-label">City</label>
                                                    <input type="text" class="form-control" id="inputCity">
                                                </div>
                                                <div class="mb-3 col-md-4">
                                                    <label for="inputState" class="form-label">State</label>
                                                    <select id="inputState" class="form-select">
                                                        <option>Choose</option>
                                                        <option>Option 1</option>
                                                        <option>Option 2</option>
                                                        <option>Option 3</option>
                                                    </select>
                                                </div>
                                                <div class="mb-3 col-md-2">
                                                    <label for="inputZip" class="form-label">Zip</label>
                                                    <input type="text" class="form-control" id="inputZip">
                                                </div>
                                            </div>

                                            <div class="mb-3">
                                                <div class="form-check">
                                                    <input type="checkbox" class="form-check-input" id="customCheck11">
                                                    <label class="form-check-label" for="customCheck11">Check this custom checkbox</label>
                                                </div>
                                            </div>

                                            <button type="submit" class="btn btn-primary waves-effect waves-light">Sign in</button>

                                        </form>

                                    </div> <!-- end card-body -->
                                </div> <!-- end card-->
                            </div> <!-- end col -->
                        </div>
                        <!-- end row -->


                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <h4 class="header-title">Custom checkbox - Basic</h4>
        
                                                <p class="sub-header">
                                                    Supports bootstrap brand colors: <code>.form-check</code>,
                                                    <code>.form-check-*</code> etc.
                                                </p>
        
                                                <div class="form-check mb-2 form-check-primary">
                                                    <input class="form-check-input" type="checkbox" value="" id="customckeck1" checked>
                                                    <label class="form-check-label" for="customckeck1">Primary</label>
                                                </div>
        
                                                <div class="form-check mb-2 form-check-success">
                                                    <input class="form-check-input" type="checkbox" value="" id="customckeck2">
                                                    <label class="form-check-label" for="customckeck2">Success</label>
                                                </div>
        
                                                <div class="form-check mb-2 form-check-danger">
                                                    <input class="form-check-input" type="checkbox" value="" id="customckeck3" checked>
                                                    <label class="form-check-label" for="customckeck3">Danger</label>
                                                </div>
        
                                                <div class="form-check mb-2 form-check-warning">
                                                    <input class="form-check-input" type="checkbox" value="" id="customckeck4" checked>
                                                    <label class="form-check-label" for="customckeck4">Warning</label>
                                                </div>
        
                                                <div class="form-check mb-2 form-check-pink">
                                                    <input class="form-check-input" type="checkbox" value="" id="customckeck5">
                                                    <label class="form-check-label" for="customckeck5">Pink</label>
                                                </div>
        
                                                <div class="form-check mb-2 form-check-info">
                                                    <input class="form-check-input" type="checkbox" value="" id="customckeck8">
                                                    <label class="form-check-label" for="customckeck8">Info</label>
                                                </div>
        
                                                <div class="form-check mb-2 form-check-dark">
                                                    <input class="form-check-input" type="checkbox" value="" id="customckeck9" checked>
                                                    <label class="form-check-label" for="customckeck9">Dark</label>
                                                </div>
                                            </div>
        
        
                                            <div class="col-md-4">
                                                <h4 class="header-title mt-3 mt-md-0">Custom checkbox - Circled</h4>
        
                                                <p class="sub-header">
                                                    <code>.rounded-circle</code> for roundness.
                                                </p>
                                                <div class="form-check mb-2 form-check-primary">
                                                    <input class="form-check-input rounded-circle" type="checkbox" value="" id="customckeck10" checked>
                                                    <label class="form-check-label" for="customckeck10">Primary</label>
                                                </div>
        
                                                <div class="form-check mb-2 form-check-success">
                                                    <input class="form-check-input rounded-circle" type="checkbox" value="" id="customckeck11" checked>
                                                    <label class="form-check-label" for="customckeck11">Success</label>
                                                </div>
        
                                                <div class="form-check mb-2 form-check-danger">
                                                    <input class="form-check-input rounded-circle" type="checkbox" value="" id="customckeck12">
                                                    <label class="form-check-label" for="customckeck12">Danger</label>
                                                </div>
        
                                                <div class="form-check mb-2 form-check-warning">
                                                    <input class="form-check-input rounded-circle" type="checkbox" value="" id="customckeck13">
                                                    <label class="form-check-label" for="customckeck13">Warning</label>
                                                </div>
        
                                                <div class="form-check mb-2 form-check-pink">
                                                    <input class="form-check-input rounded-circle" type="checkbox" value="" id="customckeck14" checked>
                                                    <label class="form-check-label" for="customckeck14">Pink</label>
                                                </div>
        
                                                <div class="form-check mb-2 form-check-info">
                                                    <input class="form-check-input rounded-circle" type="checkbox" value="" id="customckeck16">
                                                    <label class="form-check-label" for="customckeck16">Info</label>
                                                </div>
        
                                                <div class="form-check mb-2 form-check-dark">
                                                    <input class="form-check-input rounded-circle" type="checkbox" value="" id="customckeck17" checked>
                                                    <label class="form-check-label" for="customckeck17">Dark</label>
                                                </div>
                                            </div>
        
        
                                            <div class="col-md-4">
                                                <h4 class="header-title mt-3 mt-md-0">Custom checkbox - Disabled</h4>
        
                                                <p class="sub-header">
                                                    Disabled state also supported.
                                                </p>
        
                                                <div class="form-check mb-2 form-check-primary">
                                                    <input class="form-check-input" type="checkbox" value="" id="customckeck18" disabled>
                                                    <label class="form-check-label" for="customckeck18">Can't check this</label>
                                                </div>
        
                                                <div class="form-check mb-2">
                                                    <input class="form-check-input" type="checkbox" value="" id="customckeck19" checked disabled>
                                                    <label class="form-check-label" for="customckeck19">This too</label>
                                                </div>
        
                                                <div class="form-check mb-2 form-check-warning">
                                                    <input class="form-check-input rounded-circle" type="checkbox" value="" id="customckeck20" checked disabled>
                                                    <label class="form-check-label" for="customckeck20">And this</label>
                                                </div>
        
                                                <div class="form-check mb-2 form-check-info">
                                                    <input class="form-check-input" type="checkbox" value="" id="customckeck21" checked disabled>
                                                    <label class="form-check-label" for="customckeck21">Can't check this</label>
                                                </div>
        
                                                <div class="form-check mb-2 form-check-pink">
                                                    <input class="form-check-input" type="checkbox" value="" id="customckeck22" checked disabled>
                                                    <label class="form-check-label" for="customckeck22">This too</label>
                                                </div>
                                            </div>
        
        
                                        </div> <!-- end row-->
                                    </div>
                                </div> <!-- end card-->
                            </div> <!-- end col-->
                        </div> <!-- end row -->
        
                        <!-- RADIOS -->
        
                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-4">
                                                <h4 class="header-title">Custom radio - Basic</h4>
        
                                                <p class="sub-header">
                                                    Supports bootstrap brand colors: <code>.form-check</code>,
                                                    <code>.form-check-*</code> etc.
                                                </p>
        
                                                <div class="row">
                                                    <div class="col-sm-6">
                                                        <div class="form-check mb-2">
                                                            <input class="form-check-input" type="radio" name="flexRadioDefault" id="customradio1" checked>
                                                            <label class="form-check-label" for="customradio1">Default</label>
                                                        </div>
        
                                                        <div class="form-check mb-2 form-check-success">
                                                            <input class="form-check-input" type="radio" name="flexRadioDefault" id="customradio2">
                                                            <label class="form-check-label" for="customradio2">Success</label>
                                                        </div>
        
                                                        <div class="form-check mb-2 form-check-info">
                                                            <input class="form-check-input" type="radio" name="flexRadioDefault" id="customradio3">
                                                            <label class="form-check-label" for="customradio3">Info</label>
                                                        </div>
        
                                                        <div class="form-check mb-2 form-check-danger">
                                                            <input class="form-check-input" type="radio" name="flexRadioDefault" id="customradio4">
                                                            <label class="form-check-label" for="customradio4">Danger</label>
                                                        </div>
        
                                                        <div class="form-check mb-2 form-check-info">
                                                            <input class="form-check-input" type="radio" name="flexRadioDefault" id="customradio5">
                                                            <label class="form-check-label" for="customradio5">Info</label>
                                                        </div>
        
                                                        <div class="form-check mb-2 form-check-primary">
                                                            <input class="form-check-input" type="radio" name="flexRadioDefault" id="customradio6">
                                                            <label class="form-check-label" for="customradio6">Primary</label>
                                                        </div>
        
                                                        <div class="form-check mb-2 form-check-pink">
                                                            <input class="form-check-input" type="radio" name="flexRadioDefault" id="customradio7">
                                                            <label class="form-check-label" for="customradio7">Pink</label>
                                                        </div>
        
                                                        <div class="form-check mb-2 form-check-dark">
                                                            <input class="form-check-input" type="radio" name="flexRadioDefault" id="customradio8">
                                                            <label class="form-check-label" for="customradio8">Dark</label>
                                                        </div>
                                                    </div> <!-- end col -->
        
                                                    <div class="col-sm-6">
                                                        <div class="form-check mb-2">
                                                            <input class="form-check-input" type="radio" id="customradio9">
                                                            <label class="form-check-label" for="customradio9">Default</label>
                                                        </div>
        
                                                        <div class="form-check mb-2 form-check-success">
                                                            <input class="form-check-input" type="radio" id="customradio10" checked>
                                                            <label class="form-check-label" for="customradio10">Success</label>
                                                        </div>
        
                                                        <div class="form-check mb-2 form-check-info">
                                                            <input class="form-check-input" type="radio" id="customradio11">
                                                            <label class="form-check-label" for="customradio11">Info</label>
                                                        </div>
        
                                                        <div class="form-check mb-2 form-check-danger">
                                                            <input class="form-check-input" type="radio" id="customradio12" checked>
                                                            <label class="form-check-label" for="customradio12">Danger</label>
                                                        </div>
        
                                                        <div class="form-check mb-2 form-check-info">
                                                            <input class="form-check-input" type="radio" id="customradio13">
                                                            <label class="form-check-label" for="customradio13">Info</label>
                                                        </div>
        
                                                        <div class="form-check mb-2 form-check-primary">
                                                            <input class="form-check-input" type="radio" id="customradio14" checked>
                                                            <label class="form-check-label" for="customradio14">Primary</label>
                                                        </div>
        
                                                        <div class="form-check mb-2 form-check-pink">
                                                            <input class="form-check-input" type="radio" id="customradio15">
                                                            <label class="form-check-label" for="customradio15">Pink</label>
                                                        </div>
        
                                                        <div class="form-check mb-2 form-check-dark">
                                                            <input class="form-check-input" type="radio" id="customradio16" checked>
                                                            <label class="form-check-label" for="customradio16">Dark</label>
                                                        </div>
        
                                                    </div><!-- end col -->
                                                </div> <!-- end row-->
                                            </div>
                                            <!-- end col -->
        
                                            <div class="col-md-4">
                                                <h4 class="header-title mt-3 mt-md-0">Custom radio - Disabled</h4>
                                                <p class="sub-header">
                                                    Disabled state also supported.
                                                </p>
        
                                                <div class="form-check form-check-danger mb-2">
                                                    <input class="form-check-input" type="radio" id="customradio17" checked disabled>
                                                    <label class="form-check-label" for="customradio17">Zero</label>
                                                </div>
        
                                                <div class="form-check mb-2 form-check-dark">
                                                    <input class="form-check-input" type="radio" id="customradio18" checked disabled>
                                                    <label class="form-check-label" for="customradio18">One</label>
                                                </div>
        
                                                <div class="form-check mb-2 form-check-primary">
                                                    <input class="form-check-input" type="radio" id="customradio19" checked disabled>
                                                    <label class="form-check-label" for="customradio19">Two</label>
                                                </div>
        
                                                <div class="form-check mb-2 form-check-pink">
                                                    <input class="form-check-input" type="radio" id="customradio20" checked disabled>
                                                    <label class="form-check-label" for="customradio20">Three</label>
                                                </div>
                                            </div> <!-- end col -->
        
                                        </div> <!-- end row-->
                                    </div>
                                </div> <!-- end card-->
                            </div> <!-- end col-->
                        </div><!-- end row -->
                        
                    </div> <!-- container -->

                </div> <!-- content -->

                <?php include 'partials/footer.php'; ?>

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

        <?php include 'partials/right-sidebar.php'; ?>

        <?php include 'partials/footer-scripts.php'; ?>

        <!-- App js-->
        <script src="assets/js/app.min.js"></script>
        
    </body>
</html>