<?php include 'services/session.php'; ?>
<!DOCTYPE html>
<html lang="en">

<head>

    <?php $title = "All Clients";
    include 'partials/title-meta.php'; ?>

    <?php include 'partials/head-css.php'; ?>

</head>

<?php include 'partials/body.php'; ?>

<!-- Begin page -->
<div id="wrapper">

    <?php $pagetitle = "All Clients";
    include 'partials/menu.php'; ?>
        <!-- third party css -->
        <link href="assets/libs/datatables.net-bs5/css/dataTables.bootstrap5.min.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/datatables.net-responsive-bs5/css/responsive.bootstrap5.min.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/datatables.net-buttons-bs5/css/buttons.bootstrap5.min.css" rel="stylesheet" type="text/css" />
        <link href="assets/libs/datatables.net-select-bs5/css//select.bootstrap5.min.css" rel="stylesheet" type="text/css" />
        <!-- third party css end -->
            
            <!-- ============================================================== -->
            <!-- Start Page Content here -->
            <!-- ============================================================== -->

            <div class="content-page">
                <div class="content">

                    <!-- Start Content-->
                    <div class="container-fluid">

                        <div class="row">
                            <div class="col-12">
                                <div class="card">
                                    <div class="card-body">
                                        <h4 class="mt-0 header-title">Client List</h4>
                                        <br/>
                                        <p class="text-muted font-14 mb-3" style="text-align: left;">
                                            <a href="add_client.php">
                                                <button class="btn btn-primary">Add Client</button>
                                            </a>
                                        </p>
                                        <table id="datatable-buttons" class="table table-striped table-bordered dt-responsive nowrap">
                                            <thead>
                                            <tr>
                                                <th>Name</th>
                                                <th>Phone</th>
                                                <th>Company</th>
                                                <th>State</th>
                                                <th>Email</th>
                                                <th>Start Date</th>
                                                <th>Actions</th>
                                            </tr>
                                            </thead>
    
    
                                            <tbody>
                                                <?php
                                                include('includes/dbconn.php');
                                            
                                                // Fetch data from the 'clients' table
                                                $result = mysqli_query($conn, "SELECT * FROM clients");
                                            
                                                // Assuming $user_level is defined and contains the user's level
                                                $user_level = 9; // Example user level for admin
                                            
                                                // Loop through the result set and populate the table
                                                while ($row = mysqli_fetch_assoc($result)) {
                                                    echo "<tr>";
                                                    echo "<td>" . $row['client_name'] . "</td>";
                                                    echo "<td>" . $row['phone_number'] . "</td>";
                                                    echo "<td>" . $row['company'] . "</td>";
                                                    echo "<td>" . $row['state'] . "</td>";
                                                    echo "<td>" . $row['email'] . "</td>";
                                                    echo "<td>" . $row['start_date'] . "</td>";
                                            
                                                    // Check if user has sufficient level (assuming you have user authentication)
                                                    if ($user_level >= 9) {
                                                        echo "<td class='text-center'>
                                                                  <ul class='list-inline me-auto mb-0'>
                                                                      <li class='list-inline-item align-bottom' data-bs-toggle='tooltip' title='Edit'>
                                                                          <a href='edit_client.php?id=" . $row['client_id'] . "' class='avtar avtar-xs btn-link-secondary btn-pc-default'>
                                                                              <i class='ti ti-pencil f-18'></i>
                                                                          </a>
                                                                      </li>
                                                                      <li class='list-inline-item align-bottom' data-bs-toggle='tooltip' title='View'>
                                                                          <a href='view_client.php?id=" . $row['client_id'] . "' class='avtar avtar-xs btn-link-secondary btn-pc-default'>
                                                                              <i class='ti ti-eye f-18'></i>
                                                                          </a>
                                                                      </li>
                                                                      <li class='list-inline-item align-bottom' data-bs-toggle='tooltip' title='Delete'>
                                                                          <a href='delete_client.php?id=" . $row['client_id'] . "' class='avtar avtar-xs btn-link-danger btn-pc-default'>
                                                                              <i class='ti ti-trash f-18'></i>
                                                                          </a>
                                                                      </li>
                                                                  </ul>
                                                              </td>";
                                                    } else {
                                                        // If user level is not sufficient, display a placeholder or message
                                                        echo "<td class='text-center'>Insufficient Privileges</td>";
                                                    }
                                            
                                                    echo "</tr>";
                                                }
                                            
                                                // Close the result set and connection
                                                mysqli_free_result($result);
                                                mysqli_close($conn);
                                                ?>
                                            </tbody>



                                        </table>
                                    </div>
                                </div>
                               
                            </div>
                        </div>
                        <!-- end row -->

                        
                    </div> <!-- container-fluid -->

                </div> <!-- content -->

                <?php include 'partials/footer.php'; ?>

            </div>

            <!-- ============================================================== -->
            <!-- End Page content -->
            <!-- ============================================================== -->


        </div>
        <!-- END wrapper -->

        <?php include 'partials/right-sidebar.php'; ?>

        <?php include 'partials/footer-scripts.php'; ?>

        <!-- third party js -->
        <script src="assets/libs/datatables.net/js/jquery.dataTables.min.js"></script>
        <script src="assets/libs/datatables.net-bs5/js/dataTables.bootstrap5.min.js"></script>
        <script src="assets/libs/datatables.net-responsive/js/dataTables.responsive.min.js"></script>
        <script src="assets/libs/datatables.net-responsive-bs5/js/responsive.bootstrap5.min.js"></script>
        <script src="assets/libs/datatables.net-buttons/js/dataTables.buttons.min.js"></script>
        <script src="assets/libs/datatables.net-buttons-bs5/js/buttons.bootstrap5.min.js"></script>
        <script src="assets/libs/datatables.net-buttons/js/buttons.html5.min.js"></script>
        <script src="assets/libs/datatables.net-buttons/js/buttons.flash.min.js"></script>
        <script src="assets/libs/datatables.net-buttons/js/buttons.print.min.js"></script>
        <script src="assets/libs/datatables.net-keytable/js/dataTables.keyTable.min.js"></script>
        <script src="assets/libs/datatables.net-select/js/dataTables.select.min.js"></script>
        <script src="assets/libs/pdfmake/build/pdfmake.min.js"></script>
        <script src="assets/libs/pdfmake/build/vfs_fonts.js"></script>
        <!-- third party js ends -->

        <!-- Datatables init -->
        <script src="assets/js/pages/datatables.init.js"></script>

        <!-- App js -->
        <script src="assets/js/app.min.js"></script>
        
    </body>
</html>